/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.table;

import filenet.vw.api.VWSecurityList;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.Component;
import java.awt.Font;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

public class VWUserGroupListCellRenderer
extends DefaultListCellRenderer {
    private VWSecurityList m_groupList = null;
    private Font m_boldFont = null;

    public VWUserGroupListCellRenderer(VWSecurityList groupList) {
        this.setOpaque(true);
        this.m_groupList = groupList;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String str = null;
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        this.setComponentOrientation(list.getComponentOrientation());
        str = value.toString();
        this.setText(str);
        if (this.m_groupList != null) {
            try {
                if (this.m_boldFont == null) {
                    this.m_boldFont = this.getFont();
                    if (this.m_boldFont != null) {
                        this.m_boldFont = new Font(this.m_boldFont.getName(), 1, this.m_boldFont.getSize());
                    }
                }
                while (this.m_groupList.hasNext()) {
                    if (VWStringUtils.compare(str, (String)this.m_groupList.next()) != 0) continue;
                    if (this.m_boldFont != null) {
                        this.setFont(this.m_boldFont);
                    }
                    break;
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
        return this;
    }
}

